/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.portal.ui.dispatch.actionControllers.Messages;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleController
extends AbstractActionController {
    private static final String BROWSER_CONSOLE_NAME = Messages.ConsoleController_devToolboxConsoleName;

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }

    @ControllerAction
    public Object log(Object arguments) {
        if (Platform.inDevelopmentMode()) {
            this.writeToConsole(arguments, false);
        }
        return IBrowserNotificationConstants.JSON_OK;
    }

    @ControllerAction
    public Object debug(Object arguments) {
        return this.log(arguments);
    }

    @ControllerAction
    public Object error(Object arguments) {
        this.writeToConsole(arguments, true);
        return IBrowserNotificationConstants.JSON_OK;
    }

    private void writeToConsole(Object arguments, boolean isError) {
        MessageConsole console = this.findOrCreateConsole();
        MessageConsoleStream out = console.newMessageStream();
        if (isError) {
            out.setColor(Display.getDefault().getSystemColor(3));
        } else {
            out.setColor(Display.getDefault().getSystemColor(9));
        }
        out.println(JSON.toString((Object)arguments));
    }

    private MessageConsole findOrCreateConsole() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] iConsoleArray = conMan.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (BROWSER_CONSOLE_NAME.equals(console.getName())) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        MessageConsole myConsole = new MessageConsole(BROWSER_CONSOLE_NAME, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

